/**********************************************************************
 *<
	FILE: RwParticle.h

	DESCRIPTION:	Template Utility

	CREATED BY:

	HISTORY:

 *>	Copyright (c) 1997, All Rights Reserved.
 **********************************************************************/

#ifndef __RWPARTICLE__H
#define __RWPARTICLE__H

#include "max.h"
#include "simpobj.h"
#include "istdplug.h"
#include "iparamb2.h"
#include "iparamm2.h"
#include "RpRandomClass.h"

/* Definitions

    EMITTERWIDTH and EMITTERHEIGHT are the dimensions of the emitter rectangle
	PARTICLECOUNT is the max number of live particles in the system
	PARTICLEMINSPEED is the lowest speed a new particle can be emitted at
	PARTICLEMAXSPEED is the highest speed a new particle can be emitted at
	PARTICLEANGLE defines a cone within which a new particle will
        be randomly emitted (in degrees)
	PARTICLELIFETIME the time particles exist for. In the max plugin this displays
        as number of max frames. On export this is converted to seconds, which
        are the units used in the renderware API.
	EMITTERHIDE hides the emitter from the scene
	SPAWNBURST creates particles immediately from time t=0
	PARTICLEDAMPING limits speed of particles on outer edge of emitter
    RANDOMSEED random seed given to renderware random number generator
    FORCEX/Y/Z force applied to particles (wind/gravity etc)
    PARTICLESIZE the diameter of the particle in max world units
    RENDERGROWTH the final size divided by the initial size
    RENDERASPECTRATIO the y size divided by the x size
	COLOURSTARTCOL the initial colour of the particles
	COLOURSTARTALPHA the initial alpha of the particles
	COLOURENDCOL the final colour of the particles
	COLOURENDALPHA the final alpha of the particles
*/

/*************************************************************************
 Local Defines
*/


#define RWPARTICLE_CLASS_ID	Class_ID(0x32073957, 0x2b03b37)

#define SPAWN_ROLLOUT_REF	0
#define RENDER_ROLLOUT_REF	1
#define NUM_REFS            2

enum 
{
	rwPARTICLESPAWNPARAM, 
	rwPARTICLERENDERPARAM,
	rwNUMPARAMBLOCKS
};

//rwPARTICLESPAWNPARAM
enum 
{ 
	plEMITTERWIDTH,
	plEMITTERHEIGHT,
	plPARTICLECOUNT,
	plPARTICLEMINSPEED,
	plPARTICLEMAXSPEED,
	plPARTICLEANGLE,
	plPARTICLELIFETIME,
	plEMITTERHIDE,
	plPARTICLEDAMPING,
    plRANDOMSEED,
    plFORCEX,
    plFORCEY,
    plFORCEZ
};

enum
{
	plPARTICLESIZE,
    plRENDERGROWTH,
    plRENDERASPECTRATIO,
	plCOLOURSTARTCOL,
	plCOLOURSTARTALPHA,
	plCOLOURENDCOL,
	plCOLOURENDALPHA
};

class RwParticle : public SimpleParticle 
{
    public:

    // Loading/Saving
    //		IOResult Load(ILoad *iload);
    //		IOResult Save(ISave *isave);

    //From Animatable
	Class_ID ClassID()							{ return RWPARTICLE_CLASS_ID;}		
    SClass_ID SuperClassID()					{ return GEOMOBJECT_CLASS_ID; }
    void GetClassName(TSTR& s)					{s = _T("RwParticle");}

    RefTargetHandle Clone( RemapDir &remap );
    RefResult NotifyRefChanged(Interval changeInt, RefTargetHandle hTarget, 
    PartID& partID,  RefMessage message);

    int NumSubs()								{ return 0; }
    TSTR SubAnimName(int i)						{ return _T("Spawning"); }				
    Animatable* SubAnim(int i)					{ return NULL; }

    int             NumRefs()                   { return NUM_REFS; }
    RefTargetHandle GetReference(int i);
    void            SetReference(int i, RefTargetHandle rtarg);

    int	            NumParamBlocks()            { return rwNUMPARAMBLOCKS; }	// return number of ParamBlocks in this instance
    IParamBlock2*   GetParamBlock(int i);
    IParamBlock2*   GetParamBlockByID(BlockID id);
    void            DeleteThis()                { delete this; }

    // From BaseObject
    CreateMouseCallBack	*GetCreateMouseCallBack();
	TCHAR				*GetObjectName()		{return _T("RwParticle");}
	void				 BeginEditParams(IObjParam  *ip, ULONG flags,Animatable *prev);
	void				 EndEditParams(IObjParam *ip, ULONG flags,Animatable *next);
	void				 GetWorldBoundBox(TimeValue t, INode *inode, ViewExp* vpt, Box3& box);
    
	//From GeomObject
	Mesh*				GetRenderMesh(TimeValue t, INode *inode, View& view, BOOL& needDelete);

    // From SimpleParticle
    void            UpdateParticles(TimeValue t, INode *node);
    void            BuildEmitter(TimeValue t, Mesh& amesh);
    Interval        GetValidity(TimeValue t);
    void            InvalidateUI();
	MarkerType		GetMarkerType()				{return PLUS_SIGN_MRKR;}
	ParamDimension *GetParameterDim(int pbIndex);
	BOOL			EmitterVisible();

	int				CountLiveParticles();
	float			GetParticleSize(TimeValue t, int nParticle);
	Point3			GetParticleColour(TimeValue t, int nParticle);

    //Constructor/Destructor
    RwParticle();
    //~RwParticle();	

    IParamBlock2   *pbSpawnRollout; 	    //BASIC_ROLLOUT_REF 
	IParamBlock2   *pbRenderRollout; 	    //RENDER_ROLLOUT_REF
    RpRandomClass  rRandGen;
};

class RwParticleClassDesc:public ClassDesc2 
{
	public:
	int 			IsPublic()                      {return 1;}
	void *			Create(BOOL loading = FALSE)    {return new RwParticle();}
	const TCHAR *	ClassName()                     {return _T("RwParticle");}
	SClass_ID		SuperClassID()                  {return GEOMOBJECT_CLASS_ID;}
	Class_ID		ClassID()                       {return RWPARTICLE_CLASS_ID;}
	const TCHAR* 	Category()                      {return _T("Particle Systems");}
	const TCHAR*	InternalName()                  {return _T("RwParticle"); }	// returns fixed parsable name (scripter-visible name)
	HINSTANCE		HInstance()                     {return AfxGetResourceHandle(); }	// returns owning module handle
};

class RwEmitterCreateCallback : public CreateMouseCallBack 
{
	public:
		RwParticle *pRwParticles;
		Point3      p0,p1;
		IPoint2     sp0, sp1;
		int proc( ViewExp *vpt,int msg, int point, int flags, IPoint2 m, Matrix3& mat);
};

#endif // __RWPARTICLE__H
